/* - AdvServoVelocityListener -
 * Servo velocity change event handling code
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.event.ServoVelocityChangeListener;
import com.phidgets.event.ServoVelocityChangeEvent;

import javax.swing.JComboBox;
import javax.swing.JTextField;

public class AdvServoVelocityListener implements ServoVelocityChangeListener{
    
    private JComboBox servoCmb;
    private JTextField actVelTxt;
    
    /** Creates a new instance of AdvServoVelocityListener */
    public AdvServoVelocityListener(JComboBox servoCmb, JTextField actVelTxt)
    {
        this.servoCmb = servoCmb;
        this.actVelTxt = actVelTxt;
    }

    public void servoVelocityChanged(ServoVelocityChangeEvent servoVelocityChangeEvent)
    {
        if(servoVelocityChangeEvent.getIndex() == ((Integer)servoCmb.getSelectedItem()).intValue())
        {
            actVelTxt.setText(Double.toString(servoVelocityChangeEvent.getValue()));
        }
    }
    
}
